-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema pruebas
--

-- CREATE DATABASE IF NOT EXISTS pruebas;
-- USE pruebas;

--
-- Definition of table `st_facturable`
--

DROP TABLE IF EXISTS `st_facturable`;
CREATE TABLE `st_facturable` (
  `id_st_facturable` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(10) NOT NULL,
  `titulo` varchar(50) NOT NULL,
  PRIMARY KEY (`id_st_facturable`),
  UNIQUE KEY `codigo_UNIQUE` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `st_facturable`
--

/*!40000 ALTER TABLE `st_facturable` DISABLE KEYS */;
INSERT INTO `st_facturable` (`id_st_facturable`,`codigo`,`titulo`) VALUES 
 (1,'Regalo','No facturable'),
 (2,'Garantía','Garnatía de reparación'),
 (3,'Seguro','Compañía de seguro'),
 (4,'Cliente','Facturable Cliente');
/*!40000 ALTER TABLE `st_facturable` ENABLE KEYS */;


--
-- Definition of table `st_master`
--

DROP TABLE IF EXISTS `st_master`;
CREATE TABLE `st_master` (
  `id_st_master` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(10) NOT NULL,
  `titulo` varchar(50) NOT NULL,
  `descripcion` varchar(200) DEFAULT NULL,
  `st_periodo_id` int(11) NOT NULL,
  `st_tipo_revision_id` int(11) NOT NULL,
  `st_tiempo_id` int(11) NOT NULL,
  `st_num_operarios_id` int(11) NOT NULL,
  `st_req_repuesto_id` int(11) NOT NULL,
  `st_facturable_id` int(11) NOT NULL,
  PRIMARY KEY (`id_st_master`),
  UNIQUE KEY `codigo_UNIQUE` (`codigo`),
  KEY `fk_st_master_st_periodo_idx` (`st_periodo_id`),
  KEY `fk_st_master_st_tipo_revision1_idx` (`st_tipo_revision_id`),
  KEY `fk_st_master_st_tiempo1_idx` (`st_tiempo_id`),
  KEY `fk_st_master_st_num_operarios1_idx` (`st_num_operarios_id`),
  KEY `fk_st_master_st_req_repuesto1_idx` (`st_req_repuesto_id`),
  KEY `fk_st_master_st_facturable1_idx` (`st_facturable_id`),
  CONSTRAINT `fk_st_master_st_facturable1` FOREIGN KEY (`st_facturable_id`) REFERENCES `st_facturable` (`id_st_facturable`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_st_master_st_num_operarios1` FOREIGN KEY (`st_num_operarios_id`) REFERENCES `st_num_operarios` (`id_st_num_operarios`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_st_master_st_periodo` FOREIGN KEY (`st_periodo_id`) REFERENCES `st_periodo` (`id_st_periodo`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_st_master_st_req_repuesto1` FOREIGN KEY (`st_req_repuesto_id`) REFERENCES `st_req_repuesto` (`id_st_req_repuesto`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_st_master_st_tiempo1` FOREIGN KEY (`st_tiempo_id`) REFERENCES `st_tiempo` (`id_st_tiempo`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_st_master_st_tipo_revision1` FOREIGN KEY (`st_tipo_revision_id`) REFERENCES `st_tipo_revision` (`id_st_tipo_revision`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `st_master`
--

/*!40000 ALTER TABLE `st_master` DISABLE KEYS */;
INSERT INTO `st_master` (`id_st_master`,`codigo`,`titulo`,`descripcion`,`st_periodo_id`,`st_tipo_revision_id`,`st_tiempo_id`,`st_num_operarios_id`,`st_req_repuesto_id`,`st_facturable_id`) VALUES 
 (1,'01-001','Revisión chapa y luces','Revisión visual del aspecto',1,1,1,1,1,1),
 (2,'01-002','Revisión chapa, luces,bajos y frenos','Revisión visual del aspecto',3,2,3,2,3,4),
 (3,'01-003','Cambio de Aceite y filtro','Cambio de Aceite',4,4,2,1,2,4),
 (4,'01-004','cambio filtro de Aire y/o habitáculo','Cambio de Aire y/o de habitáculo',4,4,1,1,2,4),
 (5,'01-005','Cambio Bujías','Cambio Bujías',4,4,2,1,2,4),
 (6,'02-001','Lavado Exterior coche pequeño','Lavado Exterior',1,4,1,1,3,1),
 (7,'02-002','Lavado Interior coche pequeño','Lavado Interior',1,4,3,1,3,4),
 (8,'03-001','Cambio Embrague','Cambio Embrague',5,4,11,1,2,4),
 (9,'03-002','Cambio Batería','Cambio Batería',5,4,2,1,2,4),
 (10,'04-001','Cambio rueda','Cambio rueda',5,4,1,1,2,4),
 (11,'04-002','Cambio pastillas frenos','Cambio pastillas frenos',5,4,2,1,2,4),
 (12,'02-003','Lavado Exterior coche grande','Lavado Exterior',1,4,2,1,3,1),
 (13,'02-004','Lavado Interior coche grande','Lavado Interior',1,4,4,1,3,4);
/*!40000 ALTER TABLE `st_master` ENABLE KEYS */;


--
-- Definition of table `st_num_operarios`
--

DROP TABLE IF EXISTS `st_num_operarios`;
CREATE TABLE `st_num_operarios` (
  `id_st_num_operarios` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(10) NOT NULL,
  `titulo` varchar(50) NOT NULL,
  PRIMARY KEY (`id_st_num_operarios`),
  UNIQUE KEY `codigo_UNIQUE` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `st_num_operarios`
--

/*!40000 ALTER TABLE `st_num_operarios` DISABLE KEYS */;
INSERT INTO `st_num_operarios` (`id_st_num_operarios`,`codigo`,`titulo`) VALUES 
 (1,'1','un Operario'),
 (2,'2','dos Operarios'),
 (3,'3','tres Operarios');
/*!40000 ALTER TABLE `st_num_operarios` ENABLE KEYS */;


--
-- Definition of table `st_periodo`
--

DROP TABLE IF EXISTS `st_periodo`;
CREATE TABLE `st_periodo` (
  `id_st_periodo` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(10) NOT NULL,
  `titulo` varchar(50) NOT NULL,
  PRIMARY KEY (`id_st_periodo`),
  UNIQUE KEY `codigo_UNIQUE` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `st_periodo`
--

/*!40000 ALTER TABLE `st_periodo` DISABLE KEYS */;
INSERT INTO `st_periodo` (`id_st_periodo`,`codigo`,`titulo`) VALUES 
 (1,'mes','Revisión mensual'),
 (2,'trimestre','Revisión Trimestral'),
 (3,'semestre','Revisión Semestral'),
 (4,'anual','Revisión Anual'),
 (5,'averia','Problema / Avería');
/*!40000 ALTER TABLE `st_periodo` ENABLE KEYS */;


--
-- Definition of table `st_req_repuesto`
--

DROP TABLE IF EXISTS `st_req_repuesto`;
CREATE TABLE `st_req_repuesto` (
  `id_st_req_repuesto` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(10) NOT NULL,
  `titulo` varchar(50) NOT NULL,
  PRIMARY KEY (`id_st_req_repuesto`),
  UNIQUE KEY `codigo_UNIQUE` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `st_req_repuesto`
--

/*!40000 ALTER TABLE `st_req_repuesto` DISABLE KEYS */;
INSERT INTO `st_req_repuesto` (`id_st_req_repuesto`,`codigo`,`titulo`) VALUES 
 (1,'No','No reuiere material'),
 (2,'Sí','Requiere recambio '),
 (3,'* No','Sólo requiere pequeño material');
/*!40000 ALTER TABLE `st_req_repuesto` ENABLE KEYS */;


--
-- Definition of table `st_tiempo`
--

DROP TABLE IF EXISTS `st_tiempo`;
CREATE TABLE `st_tiempo` (
  `id_st_tiempo` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(10) NOT NULL,
  `Titulo` varchar(50) NOT NULL,
  PRIMARY KEY (`id_st_tiempo`),
  UNIQUE KEY `codigo_UNIQUE` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `st_tiempo`
--

/*!40000 ALTER TABLE `st_tiempo` DISABLE KEYS */;
INSERT INTO `st_tiempo` (`id_st_tiempo`,`codigo`,`Titulo`) VALUES 
 (1,'10 min',''),
 (2,'15 min',''),
 (3,'20 min',''),
 (4,'25 min',''),
 (5,'30 min',''),
 (6,'35 min',''),
 (7,'40 min',''),
 (8,'45 min',''),
 (9,'50 min',''),
 (10,'55 min',''),
 (11,'60 min','');
/*!40000 ALTER TABLE `st_tiempo` ENABLE KEYS */;


--
-- Definition of table `st_tipo_revision`
--

DROP TABLE IF EXISTS `st_tipo_revision`;
CREATE TABLE `st_tipo_revision` (
  `id_st_tipo_revision` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(10) NOT NULL,
  `titulo` varchar(50) NOT NULL,
  PRIMARY KEY (`id_st_tipo_revision`),
  UNIQUE KEY `codigo_UNIQUE` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `st_tipo_revision`
--

/*!40000 ALTER TABLE `st_tipo_revision` DISABLE KEYS */;
INSERT INTO `st_tipo_revision` (`id_st_tipo_revision`,`codigo`,`titulo`) VALUES 
 (1,'Visual','Revisión sin desmontar'),
 (2,'+Visual','Revisión incluyendo Bajos'),
 (3,'Desmontar','Revisón desmontando'),
 (4,'Cambio','Sustitución ');
/*!40000 ALTER TABLE `st_tipo_revision` ENABLE KEYS */;


--
-- Definition of table `st_vehiculo`
--

DROP TABLE IF EXISTS `st_vehiculo`;
CREATE TABLE `st_vehiculo` (
  `id_st_vehiculo` int(11) NOT NULL AUTO_INCREMENT,
  `matricula` varchar(12) NOT NULL,
  `revision` varchar(300) DEFAULT NULL,
  `fechaCita` datetime NOT NULL,
  `fechaRevision` datetime DEFAULT NULL,
  PRIMARY KEY (`id_st_vehiculo`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `st_vehiculo`
--

/*!40000 ALTER TABLE `st_vehiculo` DISABLE KEYS */;
INSERT INTO `st_vehiculo` (`id_st_vehiculo`,`matricula`,`revision`,`fechaCita`,`fechaRevision`) VALUES 
 (1,'4582-JTR','01-002,01-003,01-004,01-005,02-001','2025-03-19 12:00:00',NULL),
 (3,'5824JGL','01-003,01-004,01-005,02-003,02-004,04-001','2025-03-15 13:41:36',NULL),
 (4,'M 951125','01-001,01-002,01-003,01-004,01-005,02-001,02-002,02-003','2025-03-15 14:00:00',NULL);
/*!40000 ALTER TABLE `st_vehiculo` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
